#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages


setup(
    name='sponge',
    author='Blueline Madagascar',
    author_email='dev@si.blueline.mg',
    version='1.8.7',
    packages=find_packages(),
    description='API gateway',
    license='MIT',
    include_package_data=True,
    install_requires=[
        'click>=6.7',
        'flask>=2.0.1',
        'flask-httpauth>=4.4.0',
        'flask-swagger>=0.2.14',
        'flask-swagger-ui>=3.36.0',
        'lxml>=4.6.3',
        'pika>=1.2.0',
        'spyne>=2.13.16',
        'systemd-python==234',
        'xmltodict>=0.12.0',
        'zeep>=4.1.0',
        'blueflask',
        'rest-client',
        'to-log'
        ],
    entry_points={
        'console_scripts': ['sponge=sponge.api.cli:cmd'],
        }
)
