#!/usr/bin/env python
# encoding: utf-8


from setuptools import setup, find_packages


setup(
    name='sponge',
    author='Blueline Madagascar',
    author_email='dev@si.blueline.mg',
    version='1.2.1',
    packages=find_packages(),
    description='API gateway',
    license='MIT',
    include_package_data=True,
    install_requires=[
        'click==6.7',
        'flask==1.0.2',
        'flask-httpauth==3.2.3',
        'flask-swagger==0.2.13',
        'flask-swagger-ui==3.6.0',
        'lxml==4.1.1',
        'pika==0.11.2',
        'spyne==2.12.11',
        'systemd-python==234',
        'xmltodict==0.11.0',
        'zeep==2.5.0',
        'blueflask',
        'rest-client==0.2',
        'to-log==0.2'
        ],
    entry_points={
        'console_scripts': ['sponge=sponge.api.cli:cmd'],
        }
)
