# -*- coding: utf-8 -*-

from flask import request

from blueflask.lib.errors import not_found
from blueflask.lib.infos import success

from ....consts import API_REGISTRY, SERVICE_CODE
from . import api


@api.route('/registry/<string:service>', methods=['GET'])
def get_service_infos_in_registry(service):
    """
    Informations sur un service dans le registre.
    ---
    tags:
      - Registry
    """
    infos = API_REGISTRY.hgetall('service:{}'.format(service))
    if not infos:
        return not_found(service_code=SERVICE_CODE)
    result = {
        key.decode('utf-8'): value.decode('utf-8')
        for key, value in infos.items()
        }
    return success(service_code=SERVICE_CODE, message=result)


@api.route('/registry', methods=['POST', 'DELETE'])
def set_info_in_registry():
    """
    Inscription d'un service au registre.
    ---
    tags:
      - Registry
    """
    data = request.get_json()
    service = data['service']
    key = 'service:{}'.format(service)
    if request.method == 'DELETE':
        if key not in [i.decode('utf-8') for i in API_REGISTRY.keys()]:
            return not_found(
                message="Ce service n'existe pas",
                service_code=SERVICE_CODE
                )
        API_REGISTRY.delete(key)
    else:
        del data['service']
        address = data['address']
        del data['address']
        API_REGISTRY.delete(key)
        API_REGISTRY.hmset(key, data)
        API_REGISTRY.set(address, data['host'])
    return success(service_code=SERVICE_CODE)

# EOF
