#!/usr/bin/env python
# encoding: utf-8


from flask import Blueprint, request

from blueflask.lib.errors import forbidden, internal_error, not_allowed
from blueflask.lib.errors import not_found
from blueflask.lib.errors import unauthorized

from ....consts import SERVICE_CODE

api = Blueprint('api', __name__)

__version__ = '1.0'


@api.errorhandler(401)
def unauthorized_error(e):
    return unauthorized(
        request_id=request.headers.get('X-Request-Id'),
        service_code=SERVICE_CODE
        )


@api.errorhandler(403)
def forbidden_error(e):
    return forbidden(
        request_id=request.headers.get('X-Request-Id'),
        service_code=SERVICE_CODE
        )


@api.errorhandler(404)
def not_found_error(e):
    return not_found(
        request_id=request.headers.get('X-Request-Id'),
        service_code=SERVICE_CODE
        )


@api.errorhandler(405)
def method_not_allowed_error(e):
    return not_allowed(
        request_id=request.headers.get('X-Request-Id'),
        service_code=SERVICE_CODE
        )


@api.errorhandler(500)
def internal_server_error(e):
    msg = 'Please contact API maintainers'
    return internal_error(
        msg,
        request_id=request.headers.get('X-Request-Id'),
        service_code=SERVICE_CODE
        )

from . import docs  # NOQA
from . import registry  # NOQA
from . import requests  # NOQA
from . import gateway  # NOQA


# EOF
