# -*- coding: utf-8 -*-

from flask import jsonify, request

from blueflask.lib.infos import HTTPInfo
from blueflask.lib.errors import HTTPError
from blueflask.lib.errors import not_found
from blueflask.lib.errors import unauthorized

from ....consts import HOSTNAME
from ....consts import SERVICE_CODE
from .... import gateway
from . import api


@api.route(
    '/<string:env>/<string:service>/v<int:version>/<path:uri>',
    methods=['GET', 'POST', 'PUT', 'DELETE']
    )
@api.route(
    '/<string:service>/v<int:version>/<path:uri>',
    methods=['GET', 'POST', 'PUT', 'DELETE']
    )
def api_gateway(service, version, uri, env=None):
    """
    API Gateway.
    ---
    tags:
      - Gateway
    """
    auth = request.authorization
    if not auth:
        return unauthorized(code='04-401')
    password = auth.password
    username = auth.username
    params = request.args or {}
    data = request.form or {}
    json_doc = request.get_json() or {}
    host = None
    if env and not HOSTNAME.startswith('api'):
        return not_found(code='04-404')
    elif env == 'dev':
        host = 'bldv040v'
    elif env == 'staging':
        host = 'blst040v'
    gw = gateway.Api(service, host=host, version=version)
    result = gw.call(
        request.method,
        '/{}'.format(uri),
        headers=request.headers,
        auth=(username, password),
        params=params,
        data=data,
        json=json_doc
        )
    status = result['status']
    content = result['content']
    if isinstance(result['content'], str):
        if status >= 400:
            response = HTTPError(
                status,
                service_code=SERVICE_CODE
                ).response(content)
        else:
            response = HTTPInfo(
                status,
                service_code=SERVICE_CODE
                ).response(content)
    else:
        response = jsonify(content)
        response.status_code = status
    return response

# EOF
