#!/usr/bin/env python
# encoding: utf-8


from to_log import Logger

import configparser
import socket

import redis

__all__ = [
    'API_REGISTRY',
    'CONFIG',
    'LOGS',
    'HOSTNAME',
    'SERVICE_CODE'
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/smsc-services/smsc-services.conf')

SERVICE_CODE = CONFIG['APP']['service_code']

HOSTNAME = socket.gethostname().split('.')[0]
API_REGISTRY = redis.Redis(db=15)

if HOSTNAME.startswith('blpr'):
    API_REGISTRY = redis.Redis(host='api.blueline.mg', db=15)

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('smsc-services')
LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

API_LOGS = Logger('smsc-services-api')
API_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

REST_CLIENT_LOGS = Logger('rest_client')
REST_CLIENT_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

SMPPLIB_LOGS = Logger('smpplib.client')
SMPPLIB_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

# EOF
