# -*- coding: utf-8 -*-

from mmpy_bot.bot import respond_to
from mmpy_bot.utils import allow_only_direct_message

from ..consts import AIGUILLIER_API, AIGUILLIER_USERNAME, AIGUILLIER_PASSWORD

from requests import get as requests_get
from requests.exceptions import Timeout


@allow_only_direct_message()
@respond_to('(.*)')
def call_jabberbot_cmd(message, commande):
    """Cette fonction permet d'appeler les commandes de bot-services"""

    payload = {
        'utilisateur': message.get_user_mail(),
        'commande': commande
    }

    # LOGS.logger.info('some logging messages')
    try:
        aiguillier_response = requests_get(
            AIGUILLIER_API,
            auth=(AIGUILLIER_USERNAME, AIGUILLIER_PASSWORD),
            params=payload
        )
    except Timeout as err_timeout:
        message.reply(
            u"La requête à Aiguillier a"
            "pris trop longtemps :\n{}".format(err_timeout)
        )
    except Exception as err:
        message.reply(
            u"Une erreur inattendue "
            "s'est produite :\n{}".format(err)
        )
    else:
        message.reply(aiguillier_response.text)
