# -*- coding: utf-8 -*-


from to_log import Logger

import configparser

import requests


__all__ = [
    'CONFIG',
    'LDAP_API',
    'LDAP_PASSWORD',
    'LDAP_USERNAME',
    'AIGUILLIER_API',
    'AIGUILLIER_PASSWORD',
    'AIGUILLIER_USERNAME',
    'LOGS',
    'get_token'
    ]


CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/shadok/shadok.conf')

LDAP_API = CONFIG['LDAP_CREDENTIALS']['ldap_api']
LDAP_USERNAME = CONFIG['LDAP_CREDENTIALS']['ldap_user']
LDAP_PASSWORD = CONFIG['LDAP_CREDENTIALS']['ldap_password']

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

AIGUILLIER_API = CONFIG['AIGUILLIER_CREDENTIALS']['aiguillier_api']
AIGUILLIER_USERNAME = CONFIG['AIGUILLIER_CREDENTIALS']['aiguillier_user']
AIGUILLIER_PASSWORD = CONFIG['AIGUILLIER_CREDENTIALS']['aiguillier_password']

LOGS = Logger('shadok-mattermost', level=LOG_LEVEL)
LOGS.set_file_handler(LOG_FILE)

REST_CLIENT_LOGS = Logger('rest_client', level=LOG_LEVEL)
REST_CLIENT_LOGS.set_file_handler(LOG_FILE)


def get_token():
    with open('/var/tmp/ldap_token') as f:
        token = f.read()
    response = requests.post(
        url=LDAP_API+'/auth/verify-token',
        auth=(token, '')
        )
    if response.status_code == 401:
        response = requests.post(
            url=LDAP_API+'/auth/request-token',
            auth=(LDAP_USERNAME, LDAP_PASSWORD)
            )
        token = response.json()['token']
        with open('/var/tmp/ldap_token', 'w') as f:
            f.write(token)
    return token

# EOF
