from flask import jsonify, request
from ...airtelmoney import AirtelMoney
from ...consts import LOGS
from . import api
import requests
import json


@api.route('/airtelmoney/paymentRequest', methods=['POST'])
def airtelPaymentRequest():
    """Launches a payment request at Airtel."""
    data = request.get_json()
    LOGS.logger.info(
        "[AirtelMoney][entrypoint]Start payment request\n"
        "{}\n\n".format(data)
    )
    airtelmoney = AirtelMoney(data)
    response = airtelmoney.paymentRequest(data)
    return jsonify(response)


@api.route('/airtelmoney/checkTransactionStatus', methods=['POST'])
def airtelCheckTransactionStatus():
    """Fetches the transaction status at Airtel."""
    data = request.get_json()
    LOGS.logger.info(
        "[AirtelMoney][entrypoint]Check transaction status\n"
        "{}\n\n".format(data)
    )
    airtelmoney = AirtelMoney(data)
    response = airtelmoney.checkTransactionStatus()
    return jsonify(response)


@api.route('/airtelmoney/callback', methods=['POST'])
def airtelCallBack():
    """API that will be called by Airtel to let us know the status of a given transaction."""
    data = request.get_json()
    LOGS.logger.info(
        "[AirtelMoney][entrypoint] start CallBack\n"
        "{}\n\n".format(data)
    )
    airtelmoney = AirtelMoney(data)
    response = airtelmoney.callBack(data)
    return jsonify(response)


@api.route("/airtelmoney/checkRedis", methods=["GET"])
def airtelCheckRedis():
    """Fetches the transaction status inside Redis."""
    data = request.get_json()
    LOGS.logger.info(
        "[AirtelMoney][entrypoint]Check transaction status Redis\n"
        "{}\n\n".format(data)
    )
    airtelmoney = AirtelMoney(data)
    response = airtelmoney.checkTransactionStatusRedis(data["operation_id"])
    return jsonify(response)


@api.route("/airtelmoney/getStatus", methods=["GET"])
def airtelGetStatus():
    """
    Fetches the transaction status directly to Airtel.
    Only used by support N1.
    """
    args = request.get_json()
    airtelmoney = AirtelMoney(args)
    response = airtelmoney.getStatus(args["operation_id"])
    return jsonify(response)

# EOF
