# odoo-services

Cette application expose une API REST permettant de communiquer avec Odoo.

## Pré-requis

L'application ne fonctionne qu'en Python3.x et requiert les paquets suivants:

* requests

* flask

* blueflask


##Installation

```
$ pip3 install -i http://miroir.blueline.mg/pypi odoo-services
```

L'application est installée:

 * vous pouvez importer le module depuis votre PYTHON_PATH
 * vous pouvez exécuter la commande _odoo-services_ qui a été installée


## Configuration

Avant toute utilisation, vous devez configurer en créant un fichier de configuration
dans `/etc/odoo-services/odoo-services.conf`.

Ce fichier est un fichier .INI qui devra se présenter comme suit:

```INI

[LOGS]                                                                               
filename = '/var/log/odoo-services/odoo-services.log'                                    
level = DEBUG                                                                        
                                                                                     
[ODOO_API]                                                                           
auth = 'http://odoo-dev.malagasy.com:10169/web/session/authenticate'                 
root = 'http://odoo-dev.malagasy.com:10169/api/v1'                                   
db = 'blueline_stock'                                                                
username = user_name                                                                    
password = pass_word

```

> le dossier de LOGS doit être créé au préalable


## Utilisation

### CLI

Lors de l'installation une interface en ligne de commande, appelée _odoo-services_ a été installée.


### API REST

Pour accéder à la documentation, lancez l'API

```
$ odoo-services runserver --host 127.0.0.1 --port 5000
```

Puis, dans votre navigateur, vous pouvez visiter http://127.0.0.1:5000/api/v1
