#!/usr/bin/env python
# encoding: utf-8

from ..consts import FILES
from ..attendance import (
    # Attendance,
    get_data,
    get_matricule,
    plus_une_minute,
    moins_une_minute
    )
from ..ussd_partner import get_record
from . import app
import click
import datetime


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(
        host=host,
        port=port,
        debug=True
        )


@cmd.command()
def sync_ussd_partner():
    get_record()


@cmd.command()
def sync_attendance():
    for file in FILES:
        with open(file, 'r') as inf:
            lines = inf.readlines()
            data = get_data(lines)
            matricules = get_matricule(data)
            for matricule in matricules:
                attendance = {
                    'matricule': matricule,
                    'attendances': {
                            'check_in': None,
                            'check_out': None
                            }
                        }
                attendance_1 = {
                    'matricule': matricule,
                    'attendances': {
                            'check_in': None,
                            'check_out': None
                            }
                        }
                p = []
                for i in data:
                    if matricule == i[0]:
                        p.append(i[1])
                        data.remove(i)
                if len(p) == 1:
                    date = datetime.datetime.strptime(
                        p[0],
                        "%d/%m/%Y %H:%M"
                        )
                    dix_heure = (datetime.datetime.strptime(
                        "10:00",
                        "%H:%M"
                        )
                    ).time()
                    sept_heure = (datetime.datetime.strptime(
                        "07:00",
                        "%H:%M"
                        )
                    ).time()
                    if sept_heure <= date.time() <= dix_heure:
                        attendance['attendances']['check_in'] = p[0]
                        attendance['attendances']['check_out'] = (
                            plus_une_minute(p[0])
                            )
                    elif date.time() <= sept_heure:
                        attendance['attendances']['check_in'] = p[0]
                        attendance['attendances']['check_out'] = (
                            plus_une_minute(p[0])
                            )
                    else:
                        attendance['attendances']['check_in'] = (
                            moins_une_minute(p[0])
                            )
                        attendance['attendances']['check_out'] = p[0]
                    click.echo(attendance)
                elif len(p) == 2:  # Entrée, Sortie
                    attendance['attendances']['check_in'] = p[0]
                    attendance['attendances']['check_out'] = p[1]
                    click.echo(attendance)
                elif len(p) == 3:  # Entrée, Sortie, Entrée ou Sortie
                    date1 = datetime.datetime.strptime(
                            p[0],
                            "%d/%m/%Y %H:%M"
                            )
                    date2 = datetime.datetime.strptime(
                            p[1],
                            "%d/%m/%Y %H:%M"
                            )
                    date3 = datetime.datetime.strptime(
                            p[2],
                            "%d/%m/%Y %H:%M"
                            )
                    dix_heure = (datetime.datetime.strptime(
                        "10:00",
                        "%H:%M"
                        )
                    ).time()
                    treize_heure = (datetime.datetime.strptime(
                        "13:30",
                        "%H:%M"
                        )
                    ).time()
                    quinze_heure = (datetime.datetime.strptime(
                        "15:00",
                        "%H:%M"
                        )
                    ).time()

                    if date1.time() <= dix_heure:
                        attendance['attendances']['check_in'] = p[0]
                        if date2.time() >= treize_heure:
                            attendance['attendances']['check_out'] = (
                                plus_une_minute(p[0])
                                    )
                            attendance_1['attendances']['check_in'] = p[1]
                            attendance_1['attendances']['check_out'] = p[2]
                        else:
                            attendance['attendances']['check_out'] = p[1]
                            if date3.time() <= quinze_heure:
                                attendance_1['attendances']['check_in'] = p[2]
                                attendance_1['attendances']['check_out'] = (
                                    plus_une_minute(p[2])
                                        )
                            else:
                                attendance_1['attendances']['check_in'] = (
                                    moins_une_minute(p[2])
                                    )
                                attendance_1['attendances']['check_out'] = p[2]
                    elif date1.time() >= dix_heure:
                        attendance['attendances']['check_in'] = (
                            moins_une_minute(p[0])
                            )
                        attendance['attendances']['check_out'] = p[0]
                        attendance_1['attendances']['check_in'] = p[1]
                        attendance_1['attendances']['check_out'] = p[2]

                    click.echo(attendance)
                    click.echo(attendance_1)
                elif len(p) == 4:  # Entrée, Sortie, Entrée, Sortie
                    attendance['attendances']['check_in'] = p[0]
                    attendance['attendances']['check_out'] = p[1]
                    attendance_1['attendances']['check_in'] = p[2]
                    attendance_1['attendances']['check_out'] = p[3]
                    click.echo(attendance)
                    click.echo(attendance_1)


if __name__ == '__main__':
    sync_attendance()
# EOF
