# -*- coding: utf-8 -*-

from . import core

import itertools


class QueryMgr(core.OCSInterface):
    def queryBalance(self, phonenumber, account_type=None):
        """Récupérer la balance d'un numéro de téléphone"""
        data = {"SubscriberNo": phonenumber, "HandleChargeFlag": 0}
        code, result = self.call_ocs("queryBalance", data, "QueryBalanceResult")
        response = {"phonenumber": "0{}".format(phonenumber)}
        if code == "405000000":
            accounts = sorted(result.BalanceRecord, key=lambda x: x.AccountType)
            accounts = itertools.groupby(accounts, key=lambda x: x.AccountType)
            accounts = {
                account_type: sum([i.Amount for i in infos])
                for account_type, infos in accounts
            }
            if account_type:
                response["balance"] = accounts[str(account_type)]
            else:
                accounts = [
                    {"account-type": account_type, "balance": balance}
                    for account_type, balance in accounts.items()
                ]
                response["accounts"] = accounts
            return code, response
        else:
            return code, result

    def queryBalanceTransferInfo(self):
        pass

    def queryCustomer(self, phonenumber):
        data = {"SubscriberNo": phonenumber}
        code, result = self.call_ocs("queryCustomer", data, "QueryCustomerResult")

        return code, result

    def queryLastTranInfo(self):
        pass

    def queryProductOrder(self):
        pass

    def querySubCosID(self):
        pass
