# -*- coding: utf-8 -*-

from .consts import LOGS, OCS_WSDL_ROOT, REDIS_DB

import datetime
import random
import requests
import zeep


__all__ = ["secret_code", "OCSInterface"]


def secret_code(phonenumber, secret_code=None, flag=False):
    """note: on stock les infos de numéros sans le premier 0,
    parce qu'au final les gens l'enlèvent ou le mettent
    comme bon leur semble"""
    key = "ocs:secretkey:{}".format(phonenumber[-9:])
    if not flag:  # on modifie le code secret
        if not secret_code:
            secret_code = ""
            while len(secret_code) < 4:
                secret_code = "{secret_code}{random_int}".format(
                    random_int=random.randint(0, 9), secret_code=secret_code
                )
        REDIS_DB.set(key, secret_code)
    else:  # on vérifie le code secret
        return secret_code.encode("utf-8") == REDIS_DB.get(key)


class OCSInterface(object):
    """Interface représentant un client vers une interface SOAP de l'OCS"""

    def __init__(self, operator):
        name = self.__class__.__name__
        wsdl = "{}/{}Service?wsdl".format(OCS_WSDL_ROOT, name)
        service_name = "{}Service".format(name)
        if name != "SubmgrtMgr":
            # pas top, il faudrait gérer ce genre de chose
            # dans la classe fille
            port_name = "{}ServicePort".format(name)
        else:
            port_name = "SubmgrtServicePort"
        self.wsdl = wsdl
        try:
            self.client = zeep.Client(
                self.wsdl,
                transport=zeep.transports.Transport(timeout=5),
                service_name=service_name,
                port_name=port_name,
            )
        except requests.exceptions.ConnectTimeout:
            raise ConnectionError("Le serveur SOAP de l'OCS est injoignable")
        else:
            self.operator = operator
            self._response = None

    def __repr__(self):
        return "<OCSInterface {}>".format(self.wsdl)

    def call_ocs(self, command, body, param):
        header = {
            "CommandId": command,
            "Version": 1,
            "TransactionId": 1,
            "SequenceId": 1,
            "OperatorID": self.operator,
            "SerialNo": datetime.datetime.now().strftime("%d%m%Y%H%M%S%f"),
            "RequestType": "Event",
        }
        LOGS.logger.info("{}: {} {}".format(command, header, body))
        response = getattr(self.client.service, command)(header, body)
        normal = True
        # une variable pour dire que la réponse suit le schéma normal
        try:
            _result = response.ResultHeader
        except AttributeError:
            _result = response
            normal = False
        finally:
            code = _result.ResultCode
            if code != "405000000":
                result = _result.ResultDesc
            elif normal:
                result = getattr(response, param)
            else:
                result = _result
            LOGS.logger.info("{}: {} {}".format(command, code, result))
            return code, result


# EOF
