# -*- coding: utf-8 -*-

from . import core


class AdjustAccountMgr(core.OCSInterface):
    def AdjustAccount(self, phonenumber, operation=None, **kwargs):
        """Modifier un ou plusieurs comptes pour un numéro de téléphone.
        Les différentes valeurs possible de 'operation':
          * 2: ajuster la valeur du compte de x unités
          * 3: ramener la valeur du compte à x unités
          * 6: modification de la validité du solde du compte
          * 7: ajuster la valeur du compte de x unités et modifier la validité
        Exemple:
          Retirer 10 Ar du solde du 0391444744:
              AdjustAccount('391444744', 2, accounts={2000: -10})
          Mettre le solde du 0391444744 à 5000 Ar:
              AdjustAccount('391444744', 3, accounts={2000: 5000})
        """
        AdditionalInfo = kwargs.get("infos")
        # "AdditionalInfo": "Achat+\\tv+\\00043129138186+.",
        if AdditionalInfo:
            data = {
                "SubscriberNo": phonenumber,
                "OperateType": operation or 2,
                "Remark": kwargs.get("infos", "None"),
                "AdditionalInfo": "Achat+\\+{}+.".format(AdditionalInfo),
                "ModifyAcctFeeList": {"ModifyAcctFee": []},
            }
        else:
            data = {
                "SubscriberNo": phonenumber,
                "OperateType": operation or 2,
                "Remark": kwargs.get("infos", "None"),
                "ModifyAcctFeeList": {"ModifyAcctFee": []},
                "AdditionalInfo": "Action+\\+undefined+.",
            }
        if operation < 4:
            for key, value in kwargs["accounts"].items():
                data["ModifyAcctFeeList"]["ModifyAcctFee"].append(
                    {
                        "AccountType": key,
                        "CurrAcctChgAmt": value,
                        "ExpireTime": kwargs.get("expiretime", ""),
                    }
                )
        code, result = self.call_ocs("AdjustAccount", data, "AdjustAccountResult")
        return code, result
