#!/usr/local/bin python
# encoding: utf-8

from blueflask.flask_api import app

from .v1 import api
from .v1 import __version__
from .. import API_REGISTRY
from .. import LOGS
from .. import HOSTNAME
from .. import SERVICE_CODE

app.config['LOGGER_NAME'] = 'ocs-services-api'
app.config['TITLE'] = 'API OCS'
app.config['DESCRIPTION'] = "Communications avec l'OCS"
app.config['VERSION'] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)


API_REGISTRY.hmset(
    'service:ocs-services',
    {
        'service_code': SERVICE_CODE,
        'host': HOSTNAME,
        'status': 'up'
        }
    )

# EOF
