#!/usr/bin/env python
# encoding: utf-8


"""
Interface en ligne de commande pour la gestion
du contenu LDAP
"""

from ..objects import Department, User
from . import app

import click
import json
import requests


@click.group()
def cmd():
    pass
#
#
# @cmd.command()
# @click.argument("object_type", type=click.Choice(["department", "user"]))
# @click.argument("name")
# def get(object_type, name):
#     """Lire les informations d'un objet LDAP"""
#     try:
#         if object_type == "department":
#             obj = Department(name)
#         elif object_type == "user":
#             obj = User(name)
#     except IndexError:
#         click.echo(click.style("{} n'existe pas".format(name), fg="red"), err=True)
#     else:
#         response = {}
#         for key, value in obj.__dict__.items():
#             if key == "manager":
#                 value = "{name} ({identifier})".format(
#                     name=value.name, identifier=value.uid
#                 )
#             if key != "handler":
#                 response[key] = value
#         if object_type == "department":
#             response["members"] = []
#             for role in obj.roles:
#                 occupants = role.occupants or []
#                 for occupant in occupants:
#                     bar = {"name": occupant.name, "identifier": occupant.uid}
#                     response["members"].append(bar)
#         elif object_type == "user":
#             response["departement"] = obj.department.name
#         click.echo(click.style(json.dumps(response, indent=4), fg="yellow"))


@cmd.command()
@click.argument("object_type", type=click.Choice(["department", "user"]))
@click.option("--name")
def search(object_type, name):
    """Rechercher des elements LDA"""
    if object_type == "department":
        cls = Department
    elif object_type == "user":
        cls = User
    if not name:
        obj = cls.all()
    else:
        obj = cls.search(name)
    response = []
    for i in obj:
        bar = {}
        bar["name"] = i.name
        if object_type == "user":
            bar["uid"] = i.uid
        response.append(bar)
    if not response:
        click.echo(click.style("Aucun resultat", fg="red"), err=True)
    else:
        click.echo(click.style(json.dumps(response, indent=4), fg="yellow"))


@cmd.command()
@click.argument("username")
def reset(username):
    """Modification du mot de passe d'un utilisateur"""
    try:
        user = User(username)
    except ValueError:
        click.echo(
            click.style("{username} n'existe pas".format(username=username), fg="red"),
            err=True,
        )
    else:
        user.reset()


@cmd.command()
@click.option("--host", default="127.0.0.1")
@click.option("--port", default=5000)
def runserver(host, port):
    """Lancement du serveur de dev de l'API REST"""

    app.run(host=host, port=port, debug=True)


@cmd.command()
@click.argument("matricule")
def get_user(matricule):
    """Lire les informations d'un utilisateur"""
    data_emp = {'employeeNumber': matricule}
    response = requests.get(
        "https://bldv040v.blueline.mg:4401/api/v2/odoo/user",
        headers={'Content-Type': 'application/json'},
        data=json.dumps(data_emp),
    )
    click.echo(response.text)


@cmd.command()
@click.argument("matricule")
def reset_password(matricule):
    """Lire les informations d'un utilisateur"""
    data_emp = {'employeeNumber': matricule}
    response = requests.put(
        "https://bldv040v.blueline.mg:4401/api/v2/odoo/user/reset",
        headers={'Content-Type': 'application/json'},
        data=json.dumps(data_emp),
    )
    click.echo(response.text)


@cmd.command()
@click.argument("matricule")
@click.argument("departement")
@click.argument("poste")
def delete_user(matricule, departement, poste):
    """Lire les informations d'un utilisateur"""
    data_emp = {
        'employeeNumber': matricule,
        'employeeType': poste,
        'ou': departement,
    }
    response = requests.delete(
        "https://bldv040v.blueline.mg:4401/api/v2/odoo/user",
        headers={'Content-Type': 'application/json'},
        data=json.dumps(data_emp),
    )
    click.echo(response.text)

# EOF
