#!/usr/bin/env python
# encoding: utf-8

from blueflask.flask_api import app

from .v2 import api
from .v2 import __version__
from ..consts import API_REGISTRY
from ..consts import LOGS
from ..consts import HOSTNAME
from ..consts import SERVICE_CODE


app.config['LOGGER_NAME'] = 'ldap-services-api'
app.config['TITLE'] = 'API LDAP'
app.config['DESCRIPTION'] = "API pour l'annuaire LDAP de blueline"
app.config['VERSION'] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)


API_REGISTRY.hmset(
    'service:ldap-services',
    {
        'service_code': SERVICE_CODE,
        'host': HOSTNAME,
        'status': 'up'
        }
    )

# EOF
