#!/usr/bin/env python
# encoding: utf-8

import pika
import socketserver
from . import LOGS


def process(message):
    connection = pika.BlockingConnection(
        pika.ConnectionParameters(
            host="localhost",
            virtual_host="/gpstracker"
        )
    )
    channel = connection.channel()
    channel.exchange_declare(exchange="gps_tracker", exchange_type="topic")
    channel.basic_publish(
        routing_key="gps_msg",
        exchange="gps_tracker",
        properties=pika.BasicProperties(
            app_id="gps-services", delivery_mode=2
        ),
        body=message,
    )
    LOGS.logger.info("--------Envoie RabbitMQ---------")
    connection.close()


class ThreadedUDPRequestHandler(socketserver.BaseRequestHandler):
    u"""Classe qui définit ce qu'on fait exactement des données
    reçues via UDP"""
    def handle(self):
        datagram = self.request[0].strip()
        # LOGS.logger.info("Data received: {}".format(
        #     binascii.hexlify(datagram))
        #     )
        process(datagram)

# EOF
