#!/usr/bin/env python
# encoding: utf-8

import time
from datetime import datetime
# from sqlalchemy import and_
from .positions import Position
from .gpsdb import GpsDB
from . import REDIS, LOGS


class Device(object):
    """représentation d'un tracker GPS"""
    def __init__(self, imei):
        self.imei = imei

    @property
    def last_position(self):
        """récupération de la dernière position connue du device"""
        try:
            result = (REDIS.get(self.imei)).decode("utf-8")
            if not result:
                return None
            else:
                position = Position.fromjson(result)
                return position
        except Exception as exc:
            LOGS.logger.info(exc)
            return exc

    def history(self, start, stop=None):
        """récupération des traces dans le temps du device.
           start et stop sont des dates au format %Y-%m-%d %H:%M:%S"""
        if not stop:
            stop = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
        kwargs = {
            "imei": self.imei,
            "start": start,
            "stop": stop
            }
        gpsdb = GpsDB()
        tracks = gpsdb.select_tracks(**kwargs)
        if not tracks:
            return None
        else:
            result = []
            for track in tracks:
                timestamp = time.mktime(track.datetime.timetuple())
                position = Position(
                    timestamp,
                    track.longitude,
                    track.latitude,
                    track.angle,
                    track.speed
                    )
                result.append(position)
            return result

    def json(self):
        result = {
            'imei': self.imei,
            'last_position': self.last_position.json()
            }
        return result

    def __repr__(self):
        return '<Device {}>'.format(self.imei)

# EOF
