# Services de gestion des politiques de bon usage (FUP)


Cette application permet d'appliquer les politiques de _fair usage_ pour les
clients blueline.

Une politique de _fair usage_ est une politique de ralentissement/augmentation de débit
descendant si la consommation du client, sur les 30 derniers jours, sur une plage horaire est
supérieure/inférieure à une valeur donnée.


## Pré-requis

 * click
 * pytz
 * redis
 * tzlocal
 * blueflask
 * rest_client
 * to_log


## Installation

```
$ pip3 install --index http://miroir.blueline.mg/pypi fup-services
```

Une fois l'application installée, un utilitaire en CLI est disponible en tant qu'exécutable
dans votre environnement.

Et vous avez le loisir de faire:

```python
>>> from fup_services.core import Product
>>> business_plus = Product('business_plus')
>>> customers = business_plus.customers
```

## Configuration

L'application doit être configurée avant toute utilisation.

Cette configuration doit se trouver dans `/etc/fup-services/fup-services.conf`.

C'est un fichier de type .INI devant comporter les paramètres ci-dessous:

```INI

[AIGUILLIER]
url = http://aiguillier.malagasy.com/rest/fup
username = votre_username_pour_aiguillier
password = votre_password_pour_aiguillier

[DATABASE]
server = 127.0.0.1
port = 6379
db = 0
password = 'something_if_necessary'

[LOGS]
filepath = /var/log/fup-services/fup-services.log
level = INFO

[POLICIES]
# Fair Usage policies
# product_name = data_limit,start,stop;data_limit,start,stop;...
business_access = 50,09:00:00,18:59:59
business_plus = 150,09:00:00,18:59:59

[ALERT]
from = mail_source
to = mail_destinations
subject = sujet_du_mail_de_rapport
```
