#!/usr/bin/env python
# encoding: utf-8

"""
Ce module contient les briques de bases du service
de gestion des politiques de consommation
des utilisateurs Internet chez Blueline.

Une synchronisation des données est effectuée tous les matins
avec Aiguillier pour disposer d'une base locale afin de faire
des calculs sans craindre les ralentissements réseau. Toutes
les vérifications se font donc en local.
"""

from .consts import FUPDB_CREDENTIALS

import records


__all__ = [
    'database_url',
    'record_customer',
    'apply_product_policies',
    'update_customer_cdr'
    ]


def database_url(**kwargs):
    url = '{eng}://{user}:{password}@{host}:{port}/{name}'.format(
        eng=kwargs.get('engine'),
        user=kwargs.get('user'),
        password=kwargs.get('password'),
        host=kwargs.get('host'),
        port=kwargs.get('port'),
        name=kwargs.get('name')
        )
    return url


def record_customer(infos):
    url = database_url(**FUPDB_CREDENTIALS)
    with records.Database(url) as db:
        sql = (
            "INSERT INTO customer (name, refnum, product) "
            "VALUES (:name, :refnum, :product)"
            )
        db.query(
            sql,
            name=infos['name'],
            refnum=infos['refnum'],
            product=infos['product']
            )


def apply_product_policies(for_real, customer):
    """Sous routine appliquant les politiques de bon usage
    à un client en particulier.
    Utile pour ensuite faire de l'exécution parallèle"""
    response = customer.apply_product_policies(
        for_real=for_real
        )
    data = [
        policy for policy in response
        # if 'fup_in' in policy or 'fup_out' in policy
        ]
    return customer, data


def update_customer_cdr(customer):
    """Mise à jour des CDRs d'un client dans la base REDIS"""
    customer.get_cdr_from_aiguillier()

# EOF
