#!/usr/bin/env python
# encoding: utf-8

"""
Ce module contient les briques de bases du service
de gestion des politiques de consommation
des utilisateurs Internet chez Blueline.

Une synchronisation des données est effectuée tous les matins
avec Aiguillier pour disposer d'une base locale afin de faire
des calculs sans craindre les ralentissements réseau. Toutes
les vérifications se font donc en local.
"""


__all__ = [
    'record_customer',
    'apply_product_policies',
    'update_customer_cdr'
    ]


def record_customer(product, infos):
    from .consts import DB
    key = 'customer:{name}'.format(name=infos['name'])
    DB.hmset(
        key,
        {
            'product': infos['product'],
            'refnum': infos['refnum']
            }
        )
    policies = product.policies
    for policy_name in policies:
        key = 'fup:{customer_name}:{policy_name}'.format(
            customer_name=infos['name'],
            policy_name=policy_name
            )
        DB.hset(key, 'status', False)


def apply_product_policies(for_real, customer):
    """Sous routine appliquant les politiques de bon usage
    à un client en particulier.
    Utile pour ensuite faire de l'exécution parallèle"""
    response = customer.apply_product_policies(
        for_real=for_real
        )
    data = [
        policy for policy in response
        # if 'fup_in' in policy or 'fup_out' in policy
        ]
    return customer, data


def update_customer_cdr(customer):
    """Mise à jour des CDRs d'un client dans la base REDIS"""
    customer.get_cdr_from_aiguillier()

# EOF
