#!/usr/bin/env python
# encoding: utf-8

from blueflask.flask_api import app

from .v1 import api
from .v1 import __version__
from .. import API_REGISTRY
from .. import LOGS
from .. import HOSTNAME
from .. import SERVICE_CODE

app.config['LOGGER_NAME'] = 'fup-services-api'
app.config['TITLE'] = 'API FUP'
app.config['DESCRIPTION'] = "Gestion des politiques de bon usage"
app.config['VERSION'] = __version__
app.logger.handlers = LOGS.logger.handlers
app.register_blueprint(api)


API_REGISTRY.hmset(
    'service:fup-services',
    {
        'service_code': SERVICE_CODE,
        'host': HOSTNAME,
        'status': 'up'
        }
    )
# EOF
