# -*- coding: utf-8 -*-

from .consts import CONFIG

import shlex
import subprocess


def dtplay(filepath, service_id, output=1, bg=False):
    """Diffusion d'un fichier via DtPlay"""
    # TODO: vérifier si le filepath existe, si non remplacer
    # par /opt/dvbbox/tsfiles/ba_ctv_end_2015.ts
    cmd = (
        "/usr/local/bin/DtPlay {0} "
        "-r {1} -i {2} -ipa {3} -ipt 10"
        ).format(
            filepath,
            CONFIG['SERVICE:{}'.format(service_id)]['bitrate'],
            output,
            CONFIG['SERVICE:{}'.format(service_id)]['udp'],
            )
    if not bg:
        subprocess.call(shlex.split(cmd))
    else:
        subprocess.Popen(shlex.split(cmd))


def vlc(xspf_file, service_id):
    """Diffusion d'un fichier via VLC"""
    cmd = (
        "cvlc %s -I telnet --telnet-host 0.0.0.0 "
        "--verbose=2 --file-logging "
        "--logfile=/var/log/dvb/dvbbox.log "
        "--telnet-password %s --telnet-port %s "
        "--sout '#standard{"
        "access=udp,"
        "mux=ts{pid-video=%s,pid-audio=%s,pcr=50},"
        "dst=%s}' --playlist-tree --ttl 10 "
        "vlc://quit") % (
            xspf_file,
            CONFIG['SERVICE:{}'.format(service_id)]['vlc_telnet_password'],
            CONFIG['SERVICE:{}'.format(service_id)]['vlc_telnet_port'],
            CONFIG['SERVICE:{}'.format(service_id)]['pid_video'],
            CONFIG['SERVICE:{}'.format(service_id)]['pid_audio'],
            CONFIG['SERVICE:{}'.format(service_id)]['udp']
            )
    process = subprocess.Popen(
        shlex.split(cmd),
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE
        )
    return process

# EOF
