# -*- coding: utf-8 -*-

from datetime import datetime
from flask import request

from blueflask.lib.errors import bad_request, not_found
from blueflask.lib.infos import success

from ... import consts, media
from . import api


@api.route('/media', methods=['GET'])
def get_all_media():
    all_media = media.Media.all()
    message = {
        'length': len(all_media),
        'media': [
            {
                'name': tsfile.filename.replace('.ts', '')
                }
            for tsfile in all_media
            ]
        }
    return success(
        message=message,
        service_code=consts.SERVICE_CODE,
        )


@api.route('/media/<string:filename>', methods=['DELETE'])
def delete_media(filename):
    tsfile = media.Media(filename)
    if not tsfile.exists:
        return not_found(
            "Le fichier {} n'existe pas".format(filename),
            service_code=consts.SERVICE_CODE
            )
    else:
        tsfile.delete()
        return success(service_code=consts.SERVICE_CODE)


@api.route('/media/<string:filename>', methods=['GET'])
def get_media(filename):
    tsfile = media.Media(filename)
    if not tsfile.exists:
        return not_found(
            "Le fichier {} n'existe pas".format(filename),
            service_code=consts.SERVICE_CODE
            )
    else:
        infos = tsfile.schedule()
        schedule = []
        program_keys = sorted(infos, key=lambda x: int(x.split(':')[1]))
        for key in program_keys:
            program_date, service_id = key.split(':')
            program_date = '{}/{}/{}'.format(
                program_date[:2],
                program_date[2:4],
                program_date[4:]
                )
            data = infos[key]
            timestamps = sorted(data)
            for timestamp in timestamps:
                schedule.append(
                    {
                        'service_id': service_id,
                        'program_date': program_date,
                        'timestamp': datetime.fromtimestamp(
                            timestamp
                            ).strftime('%d/%m/%Y %H:%M:%S')
                        }
                    )
        message = {
            'name': tsfile.filename.replace('.ts', ''),
            'duration': tsfile.duration,
            'filepath': tsfile.filepath,
            'schedule': schedule
            }
        return success(
            message=message,
            service_code=consts.SERVICE_CODE
            )


@api.route('/media/<string:filename>', methods=['POST'])
def rename_media(filename):
    tsfile = media.Media(filename)
    if not tsfile.exists:
        return not_found(
            "Le fichier {} n'existe pas".format(filename),
            service_code=consts.SERVICE_CODE
            )
    else:
        data = request.get_json()
        try:
            new_name = data['name']
        except KeyError:
            return bad_request(service_code=consts.SERVICE_CODE)
        else:
            tsfile.rename(new_name)
            return success(service_code=consts.SERVICE_CODE)


@api.route('/media/<string:filename>', methods=['PUT'])
def update_media(filename):
    tsfile = media.Media(filename)
    if not tsfile.exists:
        return not_found(
            "Le fichier {} n'existe pas".format(filename),
            service_code=consts.SERVICE_CODE
            )
    else:
        tsfile.__update__()
        return success(service_code=consts.SERVICE_CODE)

# EOF
