# -*- coding: utf-8 -*-

from datetime import datetime

from to_log import Logger

import configparser
import socket

import redis

__all__ = [
    'ADDRESS',
    'APIGW',
    'CONFIG',
    'HOSTNAME',
    'SERVICE_CODE',
    'MEDIA',
    'PROGRAMS',
    'INFOS',
    'TODAY',
    'SERVICES'
    ]

CONFIG = configparser.ConfigParser(allow_no_value=True)
CONFIG.read('/etc/dvbbox/dvbbox.conf')

SERVICE_CODE = CONFIG['APP']['service_code']
HOSTNAME = socket.gethostname().split('.')[0]
_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
_socket.connect(("41.204.103.205", 80))
ADDRESS = _socket.getsockname()[0]
APIGW = 'api.blueline.mg'

PROGRAMS = redis.Redis(host=ADDRESS)
MEDIA = redis.Redis(host=ADDRESS, db=1)
INFOS = redis.Redis(host=ADDRESS, db=15)
TODAY = datetime.now().strftime('%d%m%Y')
SERVICES = [
    int(i.split('SERVICE:')[1])
    for i in CONFIG.sections()
    if i.startswith('SERVICE:')
    ]

LOG_LEVEL = CONFIG['LOGS']['level']
LOG_FILE = CONFIG['LOGS']['filename']

LOGS = Logger('dvbbox')
LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

BLUEFLASK_LOGS = Logger('blueflask')
BLUEFLASK_LOGS.set_file_handler(filename=LOG_FILE, level=LOG_LEVEL)

# EOF
