# -*- coding: utf-8 -*-

"""
Gestion des clients dans le CAS Cryptoguard.
Par définition, un client correspond à une carte. Donc l'identificant
d'un client (customernumber) est son numéro de carte.
"""

from .core import cryptoguard_command

__all__ = [
    'add_customer',
    'add_customer_definition_channel',
    'add_customer_to_customer_group',
    'list_customer_groups_of_customer',
    'remove_customer_from_customer_group',
    'search_customers'
    ]


@cryptoguard_command()
def search_customers(**kwargs):
    """Returns the list of customers"""
    result = kwargs['result']
    customers = result['message']['Customer']
    customers = [
        i['@CustomerNumber'].replace(u'\ufeff', '') for i in customers
        ]
    result['message'] = customers
    return result


@cryptoguard_command('customernumber')
def list_customer_groups_of_customer(cardnumber, **kwargs):
    return kwargs['result']


@cryptoguard_command('customernumber', 'artnr')
def add_customer_to_customer_group(cardnumber, artnr, **kwargs):
    return kwargs['result']


@cryptoguard_command('customernumber', 'artnr')
def remove_customer_from_customer_group(cardnumber, artnr, **kwargs):
    return kwargs['result']


@cryptoguard_command('customername', 'customernumber', 'customernetid')
def add_customer(cardnumber, customernumber, customernetid, **kwargs):
    return kwargs['result']


@cryptoguard_command('cardnumber', 'artnr', 'channelid', 'monthend')
def add_customer_definition_channel(
        cardnumber,
        artnr,
        channelid,
        monthend,
        **kwargs
        ):
    return kwargs['result']


# EOF
