#!/usr/bin/env python
# encoding: utf-8


"""
Command Line Interface
"""

from . import app

import click


@click.group()
def cmd():
    pass


@cmd.command()
@click.option('--host', default='127.0.0.1')
@click.option('--port', default=5000)
def runserver(host, port):
    app.run(host=host, port=port, debug=True)


if __name__ == '__main__':
    cmd()

# EOF
